;****************************************************************************** 
;* @file    startup_py32f410xx.s
;* @author  MCU Application Team
;* @brief   PY32F410xx devices vector table for EWARM toolchain.
;*          This module performs:
;*          - Set the initial SP
;*          - Set the initial PC == __iar_program_start
;*          - Set the vector table entries with the exceptions ISR address
;*          - Branches to __main in the C library (which eventually
;*            calls main()).
;*          After Reset the CortexM4 processor is in Thread mode,
;*          priority is Privileged, and the Stack is set to Main.
;****************************************************************************** 
;* @attention
;*
;* <h2><center>&copy; Copyright (c) 2023 Puya Semiconductor Co.
;* All rights reserved.</center></h2>
;*
;* This software component is licensed by Puya under BSD 3-Clause license,
;* the "License"; You may not use this file except in compliance with the
;* License. You may obtain a copy of the License at:
;*                        opensource.org/licenses/BSD-3-Clause
;*
;******************************************************************************
;* @attention
;*
;* <h2><center>&copy; Copyright (c) 2016 STMicroelectronics.
;* All rights reserved.</center></h2>
;*
;* This software component is licensed by ST under BSD 3-Clause license,
;* the "License"; You may not use this file except in compliance with the
;* License. You may obtain a copy of the License at:
;*                        opensource.org/licenses/BSD-3-Clause
;*
;****************************************************************************** 
;
; The modules in this file are included in the libraries, and may be replaced
; by any user-defined modules that define the PUBLIC symbol _program_start or
; a user defined start symbol.
; To override the cstartup defined in the library, simply add your modified
; version to the workbench project.
;
; The vector table is normally located at address 0.
; When debugging in RAM, it can be located in RAM, aligned to at least 2^6.
; The name "__vector_table" has special meaning for C-SPY:
; it is where the SP start value is found, and the NVIC vector
; table register (VTOR) is initialized to this address if != 0.
;
; Cortex-M version
;

        MODULE  ?cstartup
        
        ;; Forward declaration of sections.
        SECTION CSTACK:DATA:NOROOT(3)

        SECTION .intvec:CODE:NOROOT(2)

        EXTERN  __iar_program_start
        EXTERN  SystemInit        
        PUBLIC  __vector_table

        DATA
__vector_table
        DCD     sfe(CSTACK)                ; Top of Stack
        DCD     Reset_Handler              ; Reset Handler
        DCD     NMI_Handler                ; NMI Handler
        DCD     HardFault_Handler          ; Hard Fault Handler
        DCD     MemManage_Handler          ; MPU Fault Handler
        DCD     BusFault_Handler           ; Bus Fault Handler
        DCD     UsageFault_Handler         ; Usage Fault Handler
        DCD     0                          ; Reserved
        DCD     0                          ; Reserved
        DCD     0                          ; Reserved
        DCD     0                          ; Reserved
        DCD     SVC_Handler                ; SVCall Handler
        DCD     DebugMon_Handler           ; Debug Monitor Handler
        DCD     0                          ; Reserved
        DCD     PendSV_Handler             ; PendSV Handler
        DCD     SysTick_Handler            ; SysTick Handler

        ; External Interrupts
        DCD     WWDG_IRQHandler               ; Window Watchdog
        DCD     PVD_IRQHandler                ; PVD through EXTI Line detect
        DCD     TAMPER_IRQHandler             ; Tamper
        DCD     RTC_IRQHandler                ; RTC
        DCD     FLASH_IRQHandler              ; Flash
        DCD     RCC_IRQHandler                ; RCC
        DCD     EXTI0_IRQHandler              ; EXTI Line 0
        DCD     EXTI1_IRQHandler              ; EXTI Line 1
        DCD     EXTI2_IRQHandler              ; EXTI Line 2
        DCD     EXTI3_IRQHandler              ; EXTI Line 3
        DCD     EXTI4_IRQHandler              ; EXTI Line 4
        DCD     EXTI9_5_IRQHandler            ; EXTI Line[9:5]
        DCD     EXTI15_10_IRQHandler          ; EXTI Line[15:10]
        DCD     DMA1_Channel1_IRQHandler      ; DMA1 Channel 1
        DCD     DMA1_Channel2_IRQHandler      ; DMA1 Channel 2
        DCD     DMA1_Channel3_IRQHandler      ; DMA1 Channel 3
        DCD     DMA1_Channel4_IRQHandler      ; DMA1 Channel 4
        DCD     DMA1_Channel5_IRQHandler      ; DMA1 Channel 5
        DCD     DMA1_Channel6_IRQHandler      ; DMA1 Channel 6
        DCD     DMA1_Channel7_IRQHandler      ; DMA1 Channel 7
        DCD     DMA1_Channel8_IRQHandler      ; DMA1 Channel 8
        DCD     ADC_IRQHandler                ; ADC
        DCD     TIM1_BRK_IRQHandler           ; TIM1 Break
        DCD     TIM1_UP_IRQHandler            ; TIM1 Update 
        DCD     TIM1_TRG_COM_IRQHandler       ; TIM1 Trigger and Commutation
        DCD     TIM1_CC_IRQHandler            ; TIM1 Capture Compare
        DCD     TIM2_IRQHandler               ; TIM2
        DCD     TIM3_IRQHandler               ; TIM3
        DCD     TIM4_IRQHandler               ; TIM4
        DCD     TIM6_IRQHandler               ; TIM6
        DCD     TIM7_IRQHandler               ; TIM7
        DCD     TIM15_IRQHandler              ; TIM15
        DCD     TIM16_IRQHandler              ; TIM16
        DCD     TIM17_IRQHandler              ; TIM17
        DCD     PWM1_IRQHandler               ; PWM1
        DCD     PWM2_IRQHandler               ; PWM2
        DCD     PWM3_IRQHandler               ; PWM3
        DCD     PWM4_IRQHandler               ; PWM4
        DCD     LPTIM_IRQHandler              ; LPTIM
        DCD     SPI1_IRQHandler               ; SPI1
        DCD     SPI2_IRQHandler               ; SPI2
        DCD     USART_IRQHandler              ; USART
        DCD     UART1_IRQHandler              ; UART1
        DCD     UART2_IRQHandler              ; UART2
        DCD     LPUART_IRQHandler             ; LPUART
        DCD     RTC_Alarm_IRQHandler          ; RTC Alarm through EXTI Line
        DCD     I2C1_EV_IRQHandler            ; I2C1 Event
        DCD     I2C1_ER_IRQHandler            ; I2C1 Error
        DCD     I2C2_EV_IRQHandler            ; I2C2 Event
        DCD     I2C2_ER_IRQHandler            ; I2C2 Error
        DCD     COMP1_IRQHandler              ; COMP1
        DCD     COMP2_IRQHandler              ; COMP2
        DCD     OPA2_IRQHandler               ; OPA2

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; Default interrupt handlers.
;;
        THUMB

        PUBWEAK Reset_Handler
        SECTION .text:CODE:REORDER:NOROOT(2)
Reset_Handler
        LDR     R0, =SystemInit
        BLX     R0
        LDR     R0, =__iar_program_start
        BX      R0
        
        PUBWEAK NMI_Handler
        SECTION .text:CODE:REORDER:NOROOT(1)
NMI_Handler
        B NMI_Handler

        PUBWEAK HardFault_Handler
        SECTION .text:CODE:REORDER:NOROOT(1)
HardFault_Handler
        B HardFault_Handler

        PUBWEAK MemManage_Handler
        SECTION .text:CODE:REORDER:NOROOT(1)
MemManage_Handler
        B MemManage_Handler

        PUBWEAK BusFault_Handler
        SECTION .text:CODE:REORDER:NOROOT(1)
BusFault_Handler
        B BusFault_Handler

        PUBWEAK UsageFault_Handler
        SECTION .text:CODE:REORDER:NOROOT(1)
UsageFault_Handler
        B UsageFault_Handler

        PUBWEAK SVC_Handler
        SECTION .text:CODE:REORDER:NOROOT(1)
SVC_Handler
        B SVC_Handler

        PUBWEAK DebugMon_Handler
        SECTION .text:CODE:REORDER:NOROOT(1)
DebugMon_Handler
        B DebugMon_Handler

        PUBWEAK PendSV_Handler
        SECTION .text:CODE:REORDER:NOROOT(1)
PendSV_Handler
        B PendSV_Handler

        PUBWEAK SysTick_Handler
        SECTION .text:CODE:REORDER:NOROOT(1)
SysTick_Handler
        B SysTick_Handler

        PUBWEAK WWDG_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
WWDG_IRQHandler
        B WWDG_IRQHandler
        
        PUBWEAK PVD_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
PVD_IRQHandler
        B PVD_IRQHandler
        
        PUBWEAK TAMPER_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
TAMPER_IRQHandler
        B TAMPER_IRQHandler
        
        PUBWEAK RTC_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
RTC_IRQHandler
        B RTC_IRQHandler
        
        PUBWEAK FLASH_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
FLASH_IRQHandler
        B FLASH_IRQHandler
        
        PUBWEAK RCC_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
RCC_IRQHandler
        B RCC_IRQHandler
        
        PUBWEAK EXTI0_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
EXTI0_IRQHandler
        B EXTI0_IRQHandler
        
        PUBWEAK EXTI1_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
EXTI1_IRQHandler
        B EXTI1_IRQHandler
        
        PUBWEAK EXTI2_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
EXTI2_IRQHandler
        B EXTI2_IRQHandler
        
        PUBWEAK EXTI3_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
EXTI3_IRQHandler
        B EXTI3_IRQHandler
        
        PUBWEAK EXTI4_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
EXTI4_IRQHandler
        B EXTI4_IRQHandler

        PUBWEAK EXTI9_5_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
EXTI9_5_IRQHandler
        B EXTI9_5_IRQHandler

        PUBWEAK EXTI15_10_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
EXTI15_10_IRQHandler
        B EXTI15_10_IRQHandler
        
        PUBWEAK DMA1_Channel1_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
DMA1_Channel1_IRQHandler
        B DMA1_Channel1_IRQHandler
        
        PUBWEAK DMA1_Channel2_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
DMA1_Channel2_IRQHandler
        B DMA1_Channel2_IRQHandler
        
        PUBWEAK DMA1_Channel3_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
DMA1_Channel3_IRQHandler
        B DMA1_Channel3_IRQHandler
        
        PUBWEAK DMA1_Channel4_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
DMA1_Channel4_IRQHandler
        B DMA1_Channel4_IRQHandler
        
        PUBWEAK DMA1_Channel5_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
DMA1_Channel5_IRQHandler
        B DMA1_Channel5_IRQHandler
        
        PUBWEAK DMA1_Channel6_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
DMA1_Channel6_IRQHandler
        B DMA1_Channel6_IRQHandler
        
        PUBWEAK DMA1_Channel7_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
DMA1_Channel7_IRQHandler
        B DMA1_Channel7_IRQHandler

        PUBWEAK DMA1_Channel8_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
DMA1_Channel8_IRQHandler
        B DMA1_Channel8_IRQHandler
        
        PUBWEAK ADC_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
ADC_IRQHandler
        B ADC_IRQHandler
        
        PUBWEAK TIM1_BRK_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
TIM1_BRK_IRQHandler
        B TIM1_BRK_IRQHandler
        
        PUBWEAK TIM1_UP_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
TIM1_UP_IRQHandler
        B TIM1_UP_IRQHandler
        
        PUBWEAK TIM1_TRG_COM_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
TIM1_TRG_COM_IRQHandler
        B TIM1_TRG_COM_IRQHandler
        
        PUBWEAK TIM1_CC_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
TIM1_CC_IRQHandler
        B TIM1_CC_IRQHandler
        
        PUBWEAK TIM2_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
TIM2_IRQHandler
        B TIM2_IRQHandler
        
        PUBWEAK TIM3_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
TIM3_IRQHandler
        B TIM3_IRQHandler
        
        PUBWEAK TIM4_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
TIM4_IRQHandler
        B TIM4_IRQHandler
        
        PUBWEAK TIM6_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
TIM6_IRQHandler
        B TIM6_IRQHandler
        
        PUBWEAK TIM7_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
TIM7_IRQHandler
        B TIM7_IRQHandler
        
        PUBWEAK TIM15_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
TIM15_IRQHandler
        B TIM15_IRQHandler
        
        PUBWEAK TIM16_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
TIM16_IRQHandler
        B TIM16_IRQHandler
        
        PUBWEAK TIM17_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
TIM17_IRQHandler
        B TIM17_IRQHandler
        
        PUBWEAK PWM1_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
PWM1_IRQHandler
        B PWM1_IRQHandler
        
        PUBWEAK PWM2_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
PWM2_IRQHandler
        B PWM2_IRQHandler
        
        PUBWEAK PWM3_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
PWM3_IRQHandler
        B PWM3_IRQHandler
        
        PUBWEAK PWM4_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
PWM4_IRQHandler
        B PWM4_IRQHandler
        
        PUBWEAK LPTIM_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
LPTIM_IRQHandler
        B LPTIM_IRQHandler
        
        PUBWEAK SPI1_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
SPI1_IRQHandler
        B SPI1_IRQHandler
        
        PUBWEAK SPI2_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
SPI2_IRQHandler
        B SPI2_IRQHandler
        
        PUBWEAK USART_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
USART_IRQHandler
        B USART_IRQHandler
        
        PUBWEAK UART1_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
UART1_IRQHandler
        B UART1_IRQHandler
        
        PUBWEAK UART2_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
UART2_IRQHandler
        B UART2_IRQHandler
        
        PUBWEAK LPUART_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
LPUART_IRQHandler
        B LPUART_IRQHandler
        
        PUBWEAK RTC_Alarm_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
RTC_Alarm_IRQHandler
        B RTC_Alarm_IRQHandler
        
        PUBWEAK I2C1_EV_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
I2C1_EV_IRQHandler
        B I2C1_EV_IRQHandler
        
        PUBWEAK I2C1_ER_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
I2C1_ER_IRQHandler
        B I2C1_ER_IRQHandler
        
        PUBWEAK I2C2_EV_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
I2C2_EV_IRQHandler
        B I2C2_EV_IRQHandler
        
        PUBWEAK I2C2_ER_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
I2C2_ER_IRQHandler
        B I2C2_ER_IRQHandler
        
        PUBWEAK COMP1_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
COMP1_IRQHandler
        B COMP1_IRQHandler
        
        PUBWEAK COMP2_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
COMP2_IRQHandler
        B COMP2_IRQHandler
        
        PUBWEAK OPA2_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
OPA2_IRQHandler
        B OPA2_IRQHandler
              
        END

;************************ (C) COPYRIGHT Puya *****END OF FILE*******************
